local pn = PLAYER_1
local OPTIONSLIST_NOTESKINS = OptionRowAvailableNoteskins().Choices;

local f = Def.ActorFrame{
	Def.Sprite{
		Texture=GAMESTATE:GetCurrentSong():GetBackgroundPath();
		InitCommand=cmd(Cover;diffusealpha,.5);
	};
	LoadFont("Common Normal")..{
		Text="Noteskin picker doesn't work properly and I don't know why.\nPray it takes effect by the next song.";
		InitCommand=cmd(horizalign,left;vertalign,top;xy,5,20;);
	};
	LoadFont("Common Normal")..{
		Text="StepMania is such a buggy broken game engine.";
		InitCommand=cmd(horizalign,left;vertalign,top;xy,5,80;);
	}


};

local playerState = GAMESTATE:GetPlayerState(pn);
--This returns an instance of playerOptions, you need to set it back to the original
local playerOptions = playerState:GetPlayerOptions("ModsLevel_Preferred")
if not playerOptions:MMod() then
	playerOptions:MMod(200)
	GAMESTATE:GetPlayerState(pn):SetPlayerOptions('ModsLevel_Preferred', playerState:GetPlayerOptionsString("ModsLevel_Preferred"));
end;

local nsScroller = {
__index = {
	make_scroller=function(self)
		local s = Def.ActorScroller{
			NumItemsToDraw=6, 
			SecondsPerItem=.3, --If you change this to 0, the scroller will not move.
			--LoopScroller=true,
			--WrapScroller=true,
			TransformFunction=function(subself,offset,itemIndex,numItems)
				subself:x(60*offset):diffusealpha(math.cos(offset*math.pi/3)*.9)
			end,
			-- Scroller commands. This is an example InitCommand.
			InitCommand=function(subself)
				--Get handle on scroller
				self.scroller=subself
				subself:SetFastCatchup(true)
			end;
		}
		for _,ns in ipairs(OptionRowAvailableNoteskins().Choices) do
			s[#s+1] = NOTESKIN:LoadActorForNoteSkin("UpLeft","Tap Note",ns)
		end;
		return s;
	end;
	Left=function(self)
		if self.scroller:GetDestinationItem() > 0 then
			self.scroller:SetDestinationItem(self.scroller:GetDestinationItem()-1);
			--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Preferred"):NoteSkin(OPTIONSLIST_NOTESKINS[self.scroller:GetDestinationItem()+1])
		end;
	end;
	Right=function(self)
		if self.scroller:GetDestinationItem() < self.scroller:GetNumItems()-1 then
			self.scroller:SetDestinationItem(self.scroller:GetDestinationItem()+1);
			--SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Preferred"):NoteSkin(OPTIONSLIST_NOTESKINS[self.scroller:GetDestinationItem()+1])
		end;
	end;
}}
nsScroller = setmetatable({}, nsScroller)
--nsScroller.make_scroller();

--Surely there is a more efficient way to do this?
local scrollerItems = {
	{
		Name="Speed";
		ExportValue=function(pn)
			return (GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Preferred"):MMod() or "None")
		end;
		LeftCommand=function()
			adjustPlayerMMod(pn,-10);
		end;
		RightCommand=function()
			adjustPlayerMMod(pn,10);
		end;
		--StartCommand=
	},
	{
		Name="Noteskin";
		Scroller=nsScroller:make_scroller();
		LeftCommand=function() nsScroller.Left(nsScroller) end;
		RightCommand=function() nsScroller.Right(nsScroller) end;
		ExportValue=function() 
			--return "a" 
			return GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Preferred"):NoteSkin() or "default";
		end;
	},
	--[[{
		Name="Go Back";
		StartCommand=function() SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen") end;
		--If no export value, already assume width is 2
		--Width=2;
	},]]
	{
		Name="OK";
		StartCommand=function() 
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") 
		end;
		--Width=2;
	};
}

local function outlineGen(width, height, lineSize)
	return Def.ActorFrame{
		InitCommand=cmd(diffusealpha,0);
		GainFocusCommand=cmd(stoptweening;linear,.3;diffusealpha,1);
		LoseFocusCommand=cmd(stoptweening;linear,.3;diffusealpha,0);
		--Bottom line
		Def.Quad{
		    InitCommand=cmd(setsize,width + lineSize, lineSize;addy,height/2;--[[horizalign,0;vertalign,2]]);
		    
		};
		--Top line
		Def.Quad{
		    InitCommand=cmd(setsize,width + lineSize, lineSize;addy,-height/2;--[[horizalign,2;vertalign,0]]); --2 = right aligned
		    
		};
		--Left line
		Def.Quad{
		    InitCommand=cmd(setsize,lineSize, height + lineSize;addx,-width/2;--[[vertalign,0;horizalign,2]]); --2 = right aligned
		    
		};
		--Right line
		Def.Quad{
		    InitCommand=cmd(setsize,lineSize, height + lineSize;addx,width/2;--[[vertalign,2;horizalign,0]]); --2 = bottom aligned
		    
		};
	};
end;


local as = Def.ActorScroller{
	NumItemsToDraw=6, 
	SecondsPerItem=.3, --If you change this to 0, the scroller will not move.
	TransformFunction=function(self,offset,itemIndex,numItems)
		self:y(80*offset);
	end,

	-- Scroller commands. This is an example InitCommand.
	InitCommand=cmd(xy,SCREEN_CENTER_X,SCREEN_CENTER_Y;SetFastCatchup,true),
	--This is the input handler for the scroller.
	CodeMessageCommand=function(self, param)
		--SCREENMAN:SystemMessage(param.Name)
		if param.Name == "Up" then
			if self:GetDestinationItem() > 0 then
				self:SetDestinationItem(self:GetDestinationItem()-1);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			end;
		elseif param.Name == "Down" then
			if self:GetDestinationItem() < self:GetNumItems()-1 then
				self:SetDestinationItem(self:GetDestinationItem()+1);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			end;
		elseif param.Name == "Left" then
			local i = self:GetDestinationItem()+1
			scrollerItems[i].LeftCommand();
			self:GetChild(i):GetChild("Text"):settext(scrollerItems[i].ExportValue(pn))
			SOUND:PlayOnce(THEME:GetPathS("","nikk_fx/bubbley"));
		elseif param.Name == "Right" then
			local i = self:GetDestinationItem()+1
			scrollerItems[i].RightCommand();
			self:GetChild(i):GetChild("Text"):settext(scrollerItems[i].ExportValue(pn))
			SOUND:PlayOnce(THEME:GetPathS("","nikk_fx/bubbley"));
		elseif param.Name == "Start" then
			local cmdd = scrollerItems[self:GetDestinationItem()+1].StartCommand;
			if cmdd then
				cmdd();
			elseif self:GetDestinationItem() < self:GetNumItems()-1 then
				self:SetDestinationItem(self:GetDestinationItem()+1);
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
			end;
		elseif param.Name == "Back" then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
		--[[else
			SCREENMAN:SystemMessage("Button not handled "..param.Name);]]
		end;

		for i=1,self:GetNumItems() do
			if self:GetDestinationItem() == i-1 then
				self:GetChild(i):playcommand("GainFocus")
			else
				self:GetChild(i):playcommand("LoseFocus")
			end;
		end;
	end;
	
	OnCommand=function(self)
		self:GetChild(1):playcommand("GainFocus")
	end;
	
	--[[genScrollerItem(1,"Options");
	genScrollerItem(2,"Go Back");
	genScrollerItem(3,"Ok");]]
}

for i in ipairs(scrollerItems) do
	
	if scrollerItems[i].Scroller then
		as[#as+1] = Def.ActorFrame{
			Name=i;
			Def.Quad{
				InitCommand=cmd(setsize,150,80;horizalign,left;diffuse,{0,0,0,.5});
			};
			Def.Quad{
				InitCommand=cmd(setsize,150,80;horizalign,right;diffuse,{.5,.5,.5,.5});
			};
			scrollerItems[i].Scroller..{
				InitCommand=cmd(xy,300/4,-10);
			};
			outlineGen(300,80,2);
			LoadFont("Common Normal")..{
				Text=scrollerItems[i].Name;
				InitCommand=cmd(x,-300/4);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			};
			LoadFont("Common Normal")..{
				Name="Text";
				Text=scrollerItems[i].ExportValue(pn);
				InitCommand=cmd(xy,300/4,25;maxwidth,140);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			}
		}
	
	elseif scrollerItems[i].ExportValue then
		as[#as+1] = Def.ActorFrame{
			Name=i;
			Def.Quad{
				InitCommand=cmd(setsize,150,40;horizalign,left;diffuse,{0,0,0,.5});
			};
			Def.Quad{
				InitCommand=cmd(setsize,150,40;horizalign,right;diffuse,{.5,.5,.5,.5});
			};
			outlineGen(300,40,2);
			LoadFont("Common Normal")..{
				Text=scrollerItems[i].Name;
				InitCommand=cmd(x,-300/4);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			};
			LoadFont("Common Normal")..{
				Name="Text";
				Text=scrollerItems[i].ExportValue(pn);
				InitCommand=cmd(x,300/4);
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			}
		}
	else
		as[#as+1] = Def.ActorFrame{
			Name=i;
			Def.Quad{
				InitCommand=cmd(setsize,300,40;diffuse,{0,0,0,.5});
			};
			outlineGen(300,40,2);
			LoadFont("Common Normal")..{
				Text=scrollerItems[i].Name;
				GainFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("HoloBlue"));
				LoseFocusCommand=cmd(stoptweening;linear,.1;diffuse,Color("White"));
			}
		}
	end;
end;

f[#f+1]=as;

return f;
